/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.statistics;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.VWSIMAnimatorWorkflow;
import filenet.sim.toolkit.viewer.statistics.IVWSIMStatPanel;
import filenet.sim.toolkit.viewer.statistics.VWSIMStatisticsPanel;
import filenet.sim.toolkit.viewer.statistics.VWSIMWorkflowStatTable;
import filenet.sim.toolkit.viewer.statistics.VWSIMWorkflowStatTableModel;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWSIMWorkflowStatPanel
extends JScrollPane
implements ChangeListener,
IVWSIMStatPanel,
ItemSelectable {
    private VWSIMStatisticsPanel m_statisticsPanel = null;
    private VWSIMWorkflowStatTableModel m_tableModel = null;
    private VWSIMWorkflowStatTable m_table = null;
    private VWSIMAnimatorDataModel m_animatorDataModel = null;
    private Vector m_itemListeners = new Vector();
    protected Frame m_parentFrame = null;

    VWSIMWorkflowStatPanel(Frame parentFrame, VWSIMStatisticsPanel statisticsPanel, VWSIMAnimatorDataModel animatorDataModel) {
        this.m_parentFrame = parentFrame;
        this.m_statisticsPanel = statisticsPanel;
        this.m_animatorDataModel = animatorDataModel;
    }

    public void initialize() {
        if (this.m_animatorDataModel == null || this.m_animatorDataModel.getInitState() != 6) {
            return;
        }
        this.m_tableModel = new VWSIMWorkflowStatTableModel(this.m_animatorDataModel);
        this.m_table = new VWSIMWorkflowStatTable(this.m_parentFrame, this, this.m_tableModel);
        this.m_tableModel.initData();
        this.add(this.m_table);
        this.setViewportView(this.m_table);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JTabbedPane && this.m_table != null) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            if (tabbedPane.getSelectedComponent() == this) {
                this.m_table.tabSelected(true);
            } else {
                this.m_table.tabSelected(false);
            }
        }
    }

    public void updateInfo() {
        this.m_tableModel.fireTableDataChanged();
    }

    public Object[] getSelectedObjects() {
        if (this.m_table != null && this.m_tableModel != null) {
            int row = this.m_table.getSelectedRow();
            Object[] objs = new Object[]{this.m_tableModel.getValueAt(row)};
            return objs;
        }
        return null;
    }

    public void addItemListener(ItemListener l) {
        this.m_itemListeners.add(l);
    }

    public void removeItemListener(ItemListener l) {
        this.m_itemListeners.remove(l);
    }

    public void notifyWorkflowSelected(VWSIMAnimatorWorkflow workflow) {
        Object obj = null;
        for (int i = 0; i < this.m_itemListeners.size(); ++i) {
            obj = this.m_itemListeners.elementAt(i);
            if (obj == null || !(obj instanceof ItemListener)) continue;
            ((ItemListener)obj).itemStateChanged(new ItemEvent(this, 0, workflow, 701));
        }
    }

    public void releaseResources() {
        this.m_statisticsPanel = null;
        this.m_animatorDataModel = null;
        if (this.m_table != null) {
            this.m_table.releaseResources();
            this.m_table = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        if (this.m_itemListeners != null) {
            this.m_itemListeners.removeAllElements();
            this.m_itemListeners = null;
        }
        this.m_parentFrame = null;
        this.removeAll();
    }
}

